<?php
$hasActiveLicense = true;
if(isLoggedIn() and (request()->route()->getName() != 'manage.configuration.product_registration') and
(!getAppSettings('product_registration', 'registration_id') or sha1(array_get($_SERVER, 'HTTP_HOST', '') .
getAppSettings('product_registration', 'registration_id') . '4.5+') !== getAppSettings('product_registration',
'signature'))) {
$hasActiveLicense = false;
if(hasCentralAccess()) {
header("Location: " . route('manage.configuration.product_registration'));
exit;
}
}
$currentAppTheme ='';
 // Default theme from settings
 $currentAppTheme = getUserAppTheme()

?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e($CURRENT_LOCALE_DIRECTION); ?>">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title> <?php echo e((isset($title) and $title) ? $title : __tr('Welcome')); ?> - <?php echo e(getAppSettings('name')); ?></title>

    <!-- Light Theme Favicon -->
    <link href="<?php echo e(getAppSettings('favicon_image_url')); ?>" rel="icon">


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&family=Nunito+Sans:ital,opsz,wght@0,6..12,200..1000;1,6..12,200..1000&family=Playfair+Display:ital,wght@0,400..900;1,400..900&display=swap"
        rel="stylesheet">
    <?php echo $__env->yieldPushContent('head'); ?>
    <?php echo __yesset(
    [
    // Icons
    'static-assets/packages/fontawesome/css/all.css',
    'dist/css/common-vendorlibs.css',
    'dist/css/vendorlibs.css',
    'argon/css/argon.min.css',
    'dist/css/app.css',
    // 'dist/css/dark-theme.css'
    ]); ?>

        <!-- App Theme Change -->
        <?php if($currentAppTheme=='dark' ): ?> 
        <link rel="stylesheet" href="<?php echo e(__yesset('dist/css/dark-theme.css')); ?>">
        <!-- Dark Theme Favicon -->
        <link href="<?php echo e(getAppSettings('dark_theme_favicon_image_url')); ?>" rel="icon" media="(prefers-color-scheme: dark)">
        <?php elseif( $currentAppTheme=='system_default'): ?>
        <link rel="stylesheet" href="<?php echo e(__yesset('dist/css/dark-theme.css')); ?>"  media="(prefers-color-scheme: dark)">
        <?php endif; ?>
        <!-- /App Theme Change -->

    
    <link href="<?php echo e(route('app.load_custom_style')); ?>" rel="stylesheet"  />
    <?php if(getAppSettings('page_head_code')): ?>
    <?php echo getAppSettings('page_head_code'); ?>

    <?php endif; ?>
</head>

<body
    class="<?php if(hasVendorAccess() or hasVendorUserAccess()): ?>  <?php endif; ?> pb-5 <?php if(isLoggedIn()): ?> lw-authenticated-page <?php else: ?> lw-guest-page <?php endif; ?> <?php echo e($class ?? ''); ?>"
    x-cloak
    x-data="{disableSoundForMessageNotification:<?php echo e(getVendorSettings('is_disabled_message_sound_notification') ? 1 : 0); ?>,unreadMessagesCount:null}">
    <?php if(auth()->guard()->check()): ?>
    <?php echo $__env->make('layouts.navbars.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>

    <div class="main-content">
        <?php echo $__env->make('layouts.navbars.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php if(isDemo()): ?>
        <div class="container">
            <div class="row">
                <a class="alert alert-danger col-12 mt-md-6 mb-md--6 mt-sm-4 mb-sm--3 text-center text-white" target="_blank"
                    href="https://codecanyon.net/item/whatsjet-saas-a-whatsapp-marketing-platform-with-bulk-sending-campaigns-chat-bots/51167362">
                    <?php echo e(__tr('Please Note: We sell this script only through CodeCanyon.net at')); ?>

                    https://codecanyon.net/item/whatsjet-saas-a-whatsapp-marketing-platform-with-bulk-sending-campaigns-chat-bots/51167362
                </a>
            </div>
        </div>
        <?php endif; ?>
        <?php if($hasActiveLicense): ?>
        <?php if(hasVendorAccess()): ?>
        <div class="container">
            <div class="row">
                <div class="col-12 mt-5 mb--7 pt-5 text-center">
                    <?php
                    $vendorPlanDetails = vendorPlanDetails(null, null, getVendorId());
                    ?>
                    <?php if(!$vendorPlanDetails->hasActivePlan()): ?>
                    <div class="alert alert-danger">
                        <?php echo e($vendorPlanDetails->message); ?>

                    </div>
                    <?php elseif($vendorPlanDetails->is_expiring): ?>
                    <div class="alert alert-warning">
                        <?php echo e(__tr('Your subscription plan is expiring on __endAt__', [
                        '__endAt__' => formatDate($vendorPlanDetails->ends_at)
                        ])); ?>

                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php else: ?>
        <div class="container">
            <div class="row">
                <div class="col-12 my-5 py-5 text-center">
                    <div class="card my-5 p-5">
                        <i class="fas fa-exclamation-triangle fa-6x mb-4 text-warning"></i>
                        <div class="alert alert-danger my-5">
                            <?php echo e(__tr('Product has not been verified yet, please contact via profile or product page.')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php if(auth()->guard()->guest()): ?>
    <?php echo $__env->make('layouts.footers.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
    <?= __yesset(['dist/js/common-vendorlibs.js','dist/js/vendorlibs.js', 'argon/bootstrap/dist/js/bootstrap.bundle.min.js', 'argon/js/argon.js', 'dist/push-js/push.min.js'], true) ?>
    <?php echo $__env->yieldPushContent('js'); ?>
    <?php if(hasVendorAccess() or hasVendorUserAccess()): ?>
    
    <?php if (isset($component)) { $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.modal','data' => ['id' => 'lwScanMeDialog','header' => __tr('Scan QR Code to Start Chat')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'lwScanMeDialog','header' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__tr('Scan QR Code to Start Chat'))]); ?>
        <?php if(getVendorSettings('current_phone_number_number')): ?>
        <div class="alert alert-dark text-center text-success">
            <?php echo e(__tr('You can use following QR Codes to invite people to get connect with you on this platform.')); ?>

        </div>
        <?php if(!empty(getVendorSettings('whatsapp_phone_numbers'))): ?>
        <?php $__currentLoopData = getVendorSettings('whatsapp_phone_numbers'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $whatsappPhoneNumber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <fieldset class="text-center">
            <legend class="text-center"><?php echo e($whatsappPhoneNumber['verified_name']); ?> (<?php echo e($whatsappPhoneNumber['display_phone_number']); ?>)</legend>
            <div class="text-center">
                <img class="lw-qr-image" src="<?php echo e(route('vendor.whatsapp_qr', [
            'vendorUid' => getVendorUid(),
            'phoneNumber' => cleanDisplayPhoneNumber($whatsappPhoneNumber['display_phone_number']),
        ])); ?>">
            </div>
            <div class="form-group">
                <h3 class="text-muted"><?php echo e(__tr('Phone Number')); ?></h3>
                <h3 class="text-success"><?php echo e($whatsappPhoneNumber['display_phone_number']); ?></h3>
                <label for="lwWhatsAppQRImage<?php echo e($loop->index); ?>"><?php echo e(__tr('URL for QR Image')); ?></label>
                <div class="input-group">
                    <input type="text" class="form-control" readonly id="lwWhatsAppQRImage<?php echo e($loop->index); ?>" value="<?php echo e(route('vendor.whatsapp_qr', [
                    'vendorUid' => getVendorUid(),
                    'phoneNumber' => cleanDisplayPhoneNumber($whatsappPhoneNumber['display_phone_number']),
                ])); ?>">
                    <div class="input-group-append">
                        <button class="btn btn-outline-light" type="button"
                            onclick="lwCopyToClipboard('lwWhatsAppQRImage<?php echo e($loop->index); ?>')">
                            <?= __tr('Copy') ?>
                        </button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <h3 class="text-muted"><?php echo e(__tr('WhatsApp URL')); ?></h3>
                <div class="input-group">
                    <input type="text" class="form-control" readonly id="lwWhatsAppUrl<?php echo e($loop->index); ?>"
                        value="https://wa.me/<?php echo e(cleanDisplayPhoneNumber($whatsappPhoneNumber['display_phone_number'])); ?>">
                    <div class="input-group-append">
                        <button class="btn btn-outline-light" type="button"
                            onclick="lwCopyToClipboard('lwWhatsAppUrl<?php echo e($loop->index); ?>')">
                            <?= __tr('Copy') ?>
                        </button>
                        <a type="button" class="btn btn-outline-success" target="_blank"
                            href="https://api.whatsapp.com/send?phone=<?php echo e(cleanDisplayPhoneNumber($whatsappPhoneNumber['display_phone_number'])); ?>"><i
                                class="fab fa-whatsapp"></i> <?php echo e(__tr('WhatsApp Now')); ?></a>
                    </div>
                </div>
            </div>
        </fieldset>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <div class="alert alert-info"><?php echo e(__tr('Please resync phone numbers.')); ?></div>
        <?php endif; ?>
        <?php else: ?>
        <div class="text-danger">
            <?php echo e(__tr('Phone number does not configured yet.')); ?>

        </div>
        <?php endif; ?>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $attributes = $__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__attributesOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f)): ?>
<?php $component = $__componentOriginal64816a37b1766c5cb5d0bcd192fb685f; ?>
<?php unset($__componentOriginal64816a37b1766c5cb5d0bcd192fb685f); ?>
<?php endif; ?>
    
    <template x-if="!disableSoundForMessageNotification">
        <audio id="lwMessageAlertTone">
            <source src="<?= asset('/static-assets/audio/whatsapp-notification-tone.mp3'); ?>" type="audio/mpeg">
        </audio>
    </template>
    <?php endif; ?>
    <script>
        (function($) {
            'use strict';
            window.appConfig = {
                debug: "<?php echo e(config('app.debug')); ?>",
                csrf_token: "<?php echo e(csrf_token()); ?>",
                locale : '<?php echo e(app()->getLocale()); ?>',
                vendorUid : '<?php echo e(getVendorUid()); ?>',
                broadcast_connection_driver: "<?php echo e(getAppSettings('broadcast_connection_driver')); ?>",
                pusher : {
                    key : "<?php echo e(config('broadcasting.connections.pusher.key')); ?>",
                    cluster : "<?php echo e(config('broadcasting.connections.pusher.options.cluster')); ?>",
                    host : "<?php echo e(config('broadcasting.connections.pusher.options.host')); ?>",
                    port : "<?php echo e(config('broadcasting.connections.pusher.options.port')); ?>",
                    useTLS : "<?php echo e(config('broadcasting.connections.pusher.options.useTLS')); ?>",
                    encrypted : "<?php echo e(config('broadcasting.connections.pusher.options.encrypted')); ?>",
                    authEndpoint : "<?php echo e(url('/broadcasting/auth')); ?>"
                },
            }
        })(jQuery);
    </script>
    <?= __yesset(
        [
            'dist/js/jsware.js',
            'dist/js/app.js',
            // keep it last
            'dist/js/alpinejs.min.js',
        ],
        true,
    ) ?>
    <?php if(hasVendorAccess() or hasVendorUserAccess()): ?>
    
    <?php echo __yesset('dist/js/bootstrap.js', true); ?>

    <?php endif; ?>
    <?php echo $__env->yieldPushContent('vendorLibs'); ?>
    <script src="<?php echo e(route('vendor.load_server_compiled_js')); ?>"></script>
    <?php echo $__env->yieldPushContent('footer'); ?>
    <?php echo $__env->yieldPushContent('appScripts'); ?>
    <script>
        (function($) {
        'use strict';
        <?php if(session('alertMessage')): ?>
            showAlert("<?php echo e(session('alertMessage')); ?>", "<?php echo e(session('alertMessageType') ?? 'info'); ?>");
            <?php
                session('alertMessage', null);
                session('alertMessageType', null);
            ?>
        <?php endif; ?>
        <?php
        $isRestrictedVendorUser = (!hasVendorAccess() ? hasVendorAccess('assigned_chats_only') : false);
        ?>
        var isRestrictedVendorUser = <?php echo e($isRestrictedVendorUser ? 1 : 0); ?>,
            loggedInUserId = '<?php echo e(getUserId()); ?>';
        __Utils.setTranslation({
            'processing': "<?php echo e(__tr('processing')); ?>",
            'uploader_default_text': "<span class='filepond--label-action'><?php echo e(__tr('Drag & Drop Files or Browse')); ?></span>",
            "confirmation_yes": "<?php echo e(__tr('Yes')); ?>",
            "confirmation_no": "<?php echo e(__tr('No')); ?>"
        });
        // push notification
        if (!Push.Permission.has()) {
            Push.Permission.request();
        }
        // register service worker for push notifications
        navigator.serviceWorker.register("<?php echo e(asset('dist/push-js/serviceWorker.min.js')); ?>");
        // check if the window tab is active
        var isWindowTabActive = true;
        $(window).on("blur focus", function(e) {
            var prevType = $(this).data("prevType");
            //  reduce double fire issues
            if (prevType != e.type) {
                switch (e.type) {
                    case "blur":
                        isWindowTabActive = false;
                        break;
                    case "focus":
                        isWindowTabActive = true;
                        break;
                };
            };
            $(this).data("prevType", e.type);
        });

        <?php if(hasVendorAccess() or hasVendorUserAccess()): ?>
            var broadcastActionDebounce,
                campaignActionDebounce,
                lastEventData,
                lastCampaignStatus,
                demoNumbers;
                function arrayContains(arr, item) {
                    // Handle case where arr is null/undefined
                    if (arr == null) return false;
                    // Use the most compatible iteration method
                    var length = arr.length;
                    for (var i = 0; i < length; i++) {
                        if (arr[i] == item) {  // Loose equality comparison
                        return true;
                        }
                    }
                    return false;
                    }
                <?php if(isDemo()): ?>
                demoNumbers = <?php echo json_encode(array_unique(array_filter(array_merge([config('__misc.demo_test_recipient_contact_number')], session('__demoAccountTestPhoneNumbers') ?: []))), 512) ?>;
                <?php endif; ?>
            window.Echo.private(`vendor-channel.${window.appConfig.vendorUid}`).listen('.VendorChannelBroadcast', function (data) {
                // if the event data matched does not need to process it
                if(_.isEqual(lastEventData, data)) {
                    return true;
                }
                <?php if(isDemo()): ?>
                // prevent for other demo numbers to process
                    if(!arrayContains(demoNumbers, data.contactWaId)) {
                        return true;
                    }
                <?php endif; ?>
                if(!data.campaignUid && (!isRestrictedVendorUser || (isRestrictedVendorUser && (data.assignedUserId == loggedInUserId)))) {
                    // chat updates
                    if(isWindowTabActive && data.contactUid && $('[data-contact-uid=' + data.contactUid + ']').length) {
                        __DataRequest.get(__Utils.apiURL("<?php echo e(route('vendor.chat_message.data.read', ['contactUid', 'way'])); ?><?php echo e(((isset($assigned) and $assigned) ? '?assigned=to-me' : '')); ?>", {'contactUid': data.contactUid, 'way':'prepend'}),{}, function(responseData) {
                            __DataRequest.updateModels({
                                '@whatsappMessageLogs' : 'append',
                                'whatsappMessageLogs':responseData.client_models.whatsappMessageLogs
                            });
                            window.lwScrollTo('#lwEndOfChats', true);
                        });
                    } else if((!isRestrictedVendorUser || (isRestrictedVendorUser && (data.assignedUserId == loggedInUserId)))) {
                        // play the sound for incoming message notifications
                        if(data.isNewIncomingMessage && $('#lwMessageAlertTone').length) {
                            // play the sound
                            $('#lwMessageAlertTone')[0].play();
                            if (!isWindowTabActive) {
                                // show the notification
                            Push.create("<?php echo e(__tr('__siteName__ - New Message', [
                            '__siteName__' => getAppSettings('name')
                        ])); ?>", {
                                body: data.contactDescription,
                                icon: "<?php echo e(getAppSettings('small_logo_image_url')); ?>",
                                // timeout: 4000,
                                onClick: function () {
                                    window.focus();
                                    this.close();
                                }
                            });
                        };
                        };
                    };
                };
                lastEventData = _.cloneDeep(data);
                clearTimeout(broadcastActionDebounce);
                broadcastActionDebounce = setTimeout(function() {
                    // generic model updates
                    if(data.eventModelUpdate) {
                        __DataRequest.updateModels(data.eventModelUpdate);
                    }
                    <?php if(hasVendorAccess('messaging')): ?>
                    if(!data.campaignUid && (!isRestrictedVendorUser || (isRestrictedVendorUser && (data.assignedUserId == loggedInUserId)))) {
                        // is incoming message
                        if(data.isNewIncomingMessage) {
                            __DataRequest.get("<?php echo e(route('vendor.chat_message.read.unread_count')); ?>",{}, function(responseData) {});
                        };
                        // contact list update
                        if($('.lw-whatsapp-chat-window').length) {
                            __DataRequest.get(__Utils.apiURL("<?php echo route('vendor.contacts.data.read', ['contactUid','way' => 'append','request_contact' => '', 'assigned'=> ($assigned ?? '')]); ?>", {'contactUid': $('#lwWhatsAppChatWindow').data('contact-uid'),'request_contact' : 'request_contact=' + data.contactUid + '&'}),{}, function() {});
                        }
                    }
                    <?php endif; ?>
                }, 1000);
                <?php if(hasVendorAccess('messaging')): ?>
                // 10 seconds for campaign
                    clearTimeout(campaignActionDebounce);
                    campaignActionDebounce = setTimeout(function() {
                        // campaign data update
                        if(data.campaignUid && $('.lw-campaign-window-' + data.campaignUid).length) {
                            __DataRequest.get(__Utils.apiURL("<?php echo e(route('vendor.campaign.status.data', ['campaignUid'])); ?>", {'campaignUid': data.campaignUid}),{}, function(responseData) {
                                if(responseData.data.campaignStatus != lastCampaignStatus) {
                                    window.reloadDT('#lwCampaignQueueLog');
                                }
                                lastCampaignStatus = responseData.data.campaignStatus;
                            });
                        };
                    }, 10000);
                <?php endif; ?>
            });
        <?php if(hasVendorAccess('messaging')): ?>
        // initially get the unread count on page loads
        __DataRequest.get("<?php echo e(route('vendor.chat_message.read.unread_count')); ?>",{}, function() {});
        <?php endif; ?>
    <?php endif; ?>
    })(jQuery);
    </script>
    <?php echo getAppSettings('page_footer_code_all'); ?>

    <?php if(isLoggedIn()): ?>
    <?php echo getAppSettings('page_footer_code_logged_user_only'); ?>

    <?php endif; ?>
</body>

</html><?php /**PATH D:\waba9\resources\views/layouts/app.blade.php ENDPATH**/ ?>