<?php
/**
* Component : Campaign
* Controller : CampaignController
* File : campaign.list.blade.php
* -----------------------------------------------------------------------------
*/
?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('users.partials.header', [
'title' => __tr('Campaigns'),
'description' => '',
'class' => 'col-lg-7'
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $status = request()->status ?? 'active'; ?>
<div class="container-fluid mt-lg--6">
    <div class="row">
        <!-- button -->
        <div class="col-xl-12 mb-3">
                <a class="lw-btn btn btn-primary float-right" href="<?php echo e(route('vendor.campaign.new.view')); ?>"><?php echo e(__tr('Create New Campaign')); ?></a>
        </div>
        <!--/ button -->
        <ul class="nav nav-tabs">
        <!-- Active tab -->
					<li class="nav-item">
						<a class="nav-link <?= $status == 'active' ? 'active' : '' ?>" data-title="<?php echo e(__tr('Active')); ?>" href="<?= route('vendor.campaign.read.list_view', ['status' => 'active']) ?>">
							<?= __tr('Active') ?>
						</a>
					</li>
					<!-- /Active tab -->

					<!-- Archive tab -->
					<li class="nav-item">
						<a class="nav-link <?= $status == 'archived' ? 'active' : '' ?>  " data-title="<?php echo e(__tr('Archive')); ?>" href="<?= route('vendor.campaign.read.list_view', ['status' => 'archived']) ?>">
							<?= __tr('Archive') ?>
						</a>
					</li>
					<!-- /Archive tab -->
				</ul>

        <div class="col-xl-12">
            <?php if (isset($component)) { $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.lw.datatable','data' => ['dataPageLength' => '100','id' => 'lwCampaignList','url' => route('vendor.campaign.read.list', ['status' => $status])]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('lw.datatable'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data-page-length' => '100','id' => 'lwCampaignList','url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('vendor.campaign.read.list', ['status' => $status]))]); ?>
                <th data-orderable="true" data-name="title"><?php echo e(__tr('Title')); ?></th>
                <th data-orderable="true" data-name="template_name"><?php echo e(__tr('Template')); ?></th>
                <th data-name="contacts_count"><?php echo e(__tr('No. of Contacts')); ?></th>
                <th data-orderable="true" data-name="created_at"><?php echo e(__tr('Created At')); ?></th>
                <th data-orderable="true" data-order-type="desc" data-order-by="true" data-name="scheduled_at"><?php echo e(__tr('Schedule At')); ?></th>
                <th data-template="#campaignStatusColumnTemplate" name="null"><?php echo __tr('Status'); ?></th>
                <th data-template="#campaignActionColumnTemplate" name="null"><?php echo __tr('Action'); ?></th>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $attributes = $__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__attributesOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982)): ?>
<?php $component = $__componentOriginal49c2f9c26fb91807a4f87ab8f845e982; ?>
<?php unset($__componentOriginal49c2f9c26fb91807a4f87ab8f845e982); ?>
<?php endif; ?>
        </div>
        <!-- action template -->
        <script type="text/template" id="campaignActionColumnTemplate">
        <a href="<%= __Utils.apiURL("<?php echo e(route('vendor.campaign.status.view', ['campaignUid' => 'campaignUid',])); ?>", {'campaignUid': __tData._uid}) %>" class="btn btn-dark btn-sm" title="<?php echo e(__tr('Campaign Details')); ?>"><i class="fa fa-tachometer"></i> <?php echo e(__tr('Campaign Dashboard')); ?></a>
<!--  Delete Action -->
<% if(__tData.delete_allowed) { %>
<a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.campaign.write.delete', [ 'campaignIdOrUid'])); ?>", {'campaignIdOrUid': __tData._uid}) %>" class="btn btn-danger btn-sm lw-ajax-link-action-via-confirm" data-confirm="#lwDeleteCampaign-template" title="<?php echo e(__tr('Delete')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwCampaignList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><i class="fa fa-trash"></i> <?php echo e(__tr('Delete')); ?></a>
<% } else { %>
    <!--  Archived button -->
    <% if(__tData.status != 5) { %>
        <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.campaign.write.archive', [ 'campaignIdOrUid'])); ?>", {'campaignIdOrUid': __tData._uid}) %>" class="btn btn-danger btn-sm lw-ajax-link-action" title="<?php echo e(__tr('Archive')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwCampaignList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><?php echo e(__tr('Archive')); ?></a>
        <% } else { %>
             <!--  /Archived button -->
            <!--  UnArchived button -->
            <a data-method="post" href="<%= __Utils.apiURL("<?php echo e(route('vendor.campaign.write.unarchive', [ 'campaignIdOrUid'])); ?>", {'campaignIdOrUid': __tData._uid}) %>" class="btn btn-danger btn-sm lw-ajax-link-action" title="<?php echo e(__tr('Unarchive')); ?>" data-callback-params="<?php echo e(json_encode(['datatableId' => '#lwCampaignList'])); ?>" data-callback="appFuncs.modelSuccessCallback"><?php echo e(__tr('Unarchive')); ?></a>

            <% } %>
               <!--  /UnArchived button -->

    <% } %>
    </script>
        <!-- /action template -->
        <!-- action template -->
        <script type="text/template" id="campaignStatusColumnTemplate">
<!--  status -->
<% if(__tData.delete_allowed) { %>
    <span class="badge badge-success"><%- __tData.scheduled_status %></span>
<% } else { %>
    <span class="badge badge-warning p-2"><%- __tData.scheduled_status %></span>
<% } %>
    </script>
        <!-- /status template -->

        <!-- Campaign delete template -->
        <script type="text/template" id="lwDeleteCampaign-template">
            <h2><?php echo e(__tr('Are You Sure!')); ?></h2>
            <p><?php echo e(__tr('You want to delete this Campaign?')); ?></p>
    </script>
        <!-- /Campaign delete template -->
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => __tr('Campaigns')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/workwatsup-new.jmd-infotech.in/resources/views/campaign/list.blade.php ENDPATH**/ ?>